<?php
session_start();
require 'config.php';

if (!isset($_SESSION['status'])) { //not identified
	require 'inc/head.html';
?>
</head><body><div id="body">
	<header class="w3-center">
		<img class="w3-image w3-margin" alt="Logo de l'établissement" src="<?=$school_logo?>"/>
		<h1 class="w3-center w3-xxlarge">Stage-Dating v0.2</h1>
	</header>
	<main class="w3-flex"><form action="action-login.php" method="POST" class="w3-half w3-padding w3-center">
	<?php if (isset($_GET['error'])) { ?>
		<p class="w3-red w3-padding w3-center w3-round"><?=htmlentities($_GET['error'])?></p>
	<?php } ?>
		<input name="firstname" type="text" placeholder="Prénom" required="required" class="w3-input w3-border w3-round w3-margin-bottom"/>
		<input name="lastname" type="text" placeholder="Nom" required="required" class="w3-input w3-border w3-round w3-margin-bottom"/>
		<div class="w3-margin-bottom">
			<input type="password" id="password" name="password" class="w3-input w3-border w3-round" placeholder="Enseignant·e : mot de passe requis"/>
		</div>
	<?php if ($open_registration) { ?>
		<div class="w3-margin-bottom w3-border w3-round w3-padding">
			<p class="w3-bold">Statut (si non inscrit.e) &nbsp;:</p>
			<input class="w3-radio" type="radio" name="status" value="student" id="student"/><label for="student" class="w3-margin-right">Étudiant</label>
			<input class="w3-radio" type="radio" name="status" value="tutor" id="tutor"/><label for="tutor" class="w3-margin-right">Tuteur</label>
		</div>
	<?php } ?>
		<div><input type="submit" value="Participer" class="w3-button w3-green w3-round"/></div>
	</form></main>
	<footer class="w3-center w3-padding"><a href="legal.php">Mentions légales</a></footer>
</div></body></html>
<?php
} else { //identified
	try {
		$pdo = new PDO($db_dsn, $db_user, $db_password);
	} catch (PDOException $e) {
		print($e->getMessage());
		die();
	}
	$rs = $pdo->query('SELECT idSession FROM Participation');
	$phase = $rs->fetch(PDO::FETCH_OBJ) ? 'interview' : 'vote';
	require 'inc/' . $_SESSION['status'] . '-' . $phase . '.php'; //status ∈ ['student', 'tutor', 'teacher']
}
?>
